<?php

namespace Fatpanda\BambooConnector;

use GuzzleHttp\Client as GuzzleClient;
use Psr\Log\LoggerInterface;
use Psr\SimpleCache\CacheInterface;

abstract class BambooConnectorFactory
{
    /**
     * @param string $bambooEndpoint
     * @param string $bambooToken
     * @param CacheInterface|null $cacheHandler
     * @param LoggerInterface|null $logger
     * @return BambooConnector
     */
    public static function newInstance(string $bambooEndpoint, string $bambooToken, CacheInterface $cacheHandler = null, LoggerInterface $logger = null)
    {
        $guzzleClient = new GuzzleClient([
            'base_uri' => $bambooEndpoint,
            'connect_timeout' => 5,
            'allow_redirects' => false,
            'http_errors' => false
        ]);

        $connector = new BambooConnector(
            $guzzleClient,
            $bambooToken
        );

        if ($cacheHandler) {
            $connector->setCacheHandler($cacheHandler);
        }

        if ($logger) {
            $connector->setLogHandler($logger);
        }

        return $connector;
    }
}