<?php

namespace Fatpanda\BambooConnector\HttpFoundation;

trait CacheableRequestTrait
{
    /** @var null|bool  */
    private $cacheEnabled = null;

    /**
     * @return $this
     */
    public function enableCache()
    {
        $this->cacheEnabled = true;

        return $this;
    }

    /**
     * @return $this
     */
    public function disableCache()
    {
        $this->cacheEnabled = false;

        return $this;
    }

    /**
     * @return bool|null
     */
    public function hasCacheEnabled()
    {
        return $this->cacheEnabled;
    }
}