<?php

namespace Tests\Fatpanda\BambooConnector;

use Fatpanda\BambooConnector\BambooConnector;
use PHPUnit\Framework\TestCase;
use Psr\SimpleCache\CacheInterface;

class BambooConnectorFactoryTest extends TestCase
{
    public function test_newInstance()
    {
        // standard creation
        $connector = \Fatpanda\BambooConnector\BambooConnectorFactory::newInstance('bamboo.dev', 'token');
        $this->assertInstanceOf(BambooConnector::class,$connector);

        // cache handler
        $cacheHandler = new CacheMock();
        $connector = \Fatpanda\BambooConnector\BambooConnectorFactory::newInstance('bamboo.dev', 'token', $cacheHandler);
        $this->assertInstanceOf(CacheMock::class, $connector->getCacheHandler());

        // cache handler injected later
        $cacheHandler = new CacheMock();
        $connector = \Fatpanda\BambooConnector\BambooConnectorFactory::newInstance('bamboo.dev', 'token');
        $connector->setCacheHandler($cacheHandler);
        $this->assertInstanceOf(CacheMock::class, $connector->getCacheHandler());

        // cache handler set when enabling cache
        $cacheHandler = new CacheMock();
        $connector = \Fatpanda\BambooConnector\BambooConnectorFactory::newInstance('bamboo.dev', 'token');
        $connector->enableCache($cacheHandler);
        $this->assertInstanceOf(CacheMock::class, $connector->getCacheHandler());
    }
}

class CacheMock implements CacheInterface
{
    public function get($key, $default = null)
    {
    }

    public function set($key, $value, $ttl = null)
    {
    }

    public function delete($key)
    {
    }

    public function clear()
    {
    }

    public function getMultiple($keys, $default = null)
    {
    }

    public function setMultiple($values, $ttl = null)
    {
    }

    public function deleteMultiple($keys)
    {
    }

    public function has($key)
    {
    }
}