<?php

namespace Fatpanda\BambooConnector;

use GuzzleHttp\Client as GuzzleClient;
use Psr\SimpleCache\CacheInterface;

abstract class BambooConnectorFactory
{
    /**
     * @param string $bambooEndpoint
     * @param string $bambooToken
     * @param CacheInterface|null $cacheHandler
     * @return BambooConnector
     */
    public static function newInstance(string $bambooEndpoint, string $bambooToken, CacheInterface $cacheHandler = null)
    {
        $guzzleClient = new GuzzleClient([
            'base_uri' => $bambooEndpoint,
            'connect_timeout' => 5,
            'allow_redirects' => false,
            'http_errors' => false
        ]);

        $connector = new BambooConnector(
            $guzzleClient,
            $bambooToken
        );

        if ($cacheHandler) {
            $connector->setCacheHandler($cacheHandler);
        }

        return $connector;
    }
}