<?php

namespace Fatpanda\BambooConnector\HttpFoundation;

trait PaginatableRequestTrait
{
    /** @var null|int  */
    private $requestPage = null;

    /** @var int  */
    private $collectionCount = 25;

    /**
     * @param int $page
     * @return $this
     */
    public function setPage(int $page)
    {
        if ($page < 1) {
            throw new \InvalidArgumentException('Page must be a positive integer.');
        }

        $this->requestPage = $page;

        return $this;
    }

    /**
     * @return null|int
     */
    public function getPage()
    {
        return $this->requestPage;
    }

    /**
     * @return int|null
     */
    public function getCollectionCount()
    {
        if ($this->requestPage) {
            return $this->collectionCount;
        }

        return null;
    }

    /**
     * @param $collectionCount
     * @return $this
     */
    public function setCollectionCount($collectionCount)
    {
        $this->collectionCount = $collectionCount;

        return $this;
    }

    /**
     * @return array
     */
    public function getRangeHeaders()
    {
        $rangeHeaders = [
            'Range' => $this->getRangeString(),
            'Range-Unit' => 'items'
        ];

        return $rangeHeaders;
    }

    /**
     * @return string|null
     */
    public function getRangeString()
    {
        if ($this->requestPage) {
            $from = ($this->requestPage - 1) * $this->collectionCount;
            $to = ($from + $this->collectionCount - 1);

            return $from . '-' . $to;
        }

        return null;
    }
}